/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.server;

import filenet.vw.base.VWXMLWrapper;
import filenet.vw.base.logging.Logger;
import filenet.vw.base.util.Base64;
import filenet.vw.server.VWField;
import java.io.Serializable;
import java.util.Vector;
import org.w3c.dom.Node;

public abstract class VWWorkRecord
implements Serializable {
    public static final long FN_UNDEF_TIME = -2000000000L;
    private static final long serialVersionUID = 468L;
    protected byte[] workObjectNumber;
    protected VWField[] userFields;
    private static final String ROOT = "WR";
    private static final String ATTR_WOB = "WOB";
    protected static final Logger logger = Logger.getLogger("filenet.vw.server.VWWorkRecord");
    protected static final String m_className = "VWWorkRecord";

    public static String _get_FILE_DATE() {
        return "$Date:   13 Aug 2008 18:57:52  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.5  $";
    }

    public byte[] getWorkObjectNumber() {
        return this.workObjectNumber;
    }

    public VWField[] getUserFields() {
        return this.userFields;
    }

    protected void setWorkObjectNumber(byte[] wobNum) {
        this.workObjectNumber = wobNum;
    }

    protected void setUserFields(VWField[] usrFields) {
        this.userFields = usrFields;
    }

    private String getWOBNumInBase64() {
        return Base64.encode(this.workObjectNumber);
    }

    private void setWOBNum(String base64Data) {
        this.workObjectNumber = Base64.decode(base64Data);
    }

    public String getStringVersion() {
        try {
            StringBuffer buf = new StringBuffer();
            buf.append("<").append(ROOT).append(" ");
            buf.append(ATTR_WOB).append("=\"").append(this.getWOBNumInBase64()).append("\">");
            int nFields = this.userFields == null ? 0 : this.userFields.length;
            for (int i = 0; i < nFields; ++i) {
                this.userFields[i].asString4LastRecord(buf);
            }
            buf.append("</").append(ROOT).append(">");
            return buf.toString();
        }
        catch (Throwable t) {
            logger.throwing(m_className, "getStringVersion", t);
            return null;
        }
    }

    public static VWWorkRecord fromString(String s, Class recordCls) {
        if (s == null) {
            return null;
        }
        try {
            VWXMLWrapper xmlWrapper = new VWXMLWrapper(s);
            if (!xmlWrapper.getRootNode().getNodeName().equals(ROOT)) {
                return null;
            }
            String sWobAttr = VWXMLWrapper.getNodeAttribute(xmlWrapper.getRootNode(), ATTR_WOB);
            if (sWobAttr == null) {
                return null;
            }
            Node[] fldNodes = VWXMLWrapper.getNodesNamed(xmlWrapper.getRootNode(), "FLD");
            int nFlds = fldNodes == null ? 0 : fldNodes.length;
            Vector<VWField> v = new Vector<VWField>(nFlds);
            for (int i = 0; i < nFlds; ++i) {
                VWField f = VWField.fromXMLNode(fldNodes[i]);
                if (f == null) continue;
                v.add(f);
            }
            VWField[] usrFields = v.toArray(new VWField[0]);
            VWWorkRecord res = null;
            if (VWWorkRecord.class.isAssignableFrom(recordCls)) {
                res = (VWWorkRecord)recordCls.newInstance();
                res.setUserFields(usrFields);
                res.setWOBNum(sWobAttr);
            }
            return res;
        }
        catch (Throwable t) {
            logger.throwing(m_className, "getStringVersion", t);
            return null;
        }
    }
}

